var STATIS_FAV_IMPORT_EXPORT_PAGE_IMPORT			= 910801;		///< 统计各个来源的导入次数（即勾选）	（10801）
var STATIS_FAV_IMPORT_EXPORT_PAGE_IMPORT_SUCCESS	= 910802;		///< 各渠道的导入成功次数				（10802）
var STATIS_FAV_IMPORT_EXPORT_PAGE_CLEAN			= 910803;		///< 清空原有收藏的使用次数			（10803）
var STATIS_FAV_IMPORT_EXPORT_PAGE_CLOSE			= 910804;		///< 点击关闭或者右上角叉号的次数		（10804）
var STATIS_FAV_IMPORT_EXPORT_PAGE_BROWSE			= 910805;		///< 点击浏览的次数					（10805）
var STATIS_FAV_IMPORT_EXPORT_PAGE_EXPORT			= 910805;		///< 导出次数						（10805）
var STATIS_FAV_IMPORT_EXPORT_PAGE_EXPORT_SUCCESS	= 910806;		///< 导出成功次数					（10806）


$(function() {
	$('#import-button').focus();
	// 判断帐号是否登录
	try
	{
		qqbrowser.account.getCurrent(function(data) {
			var userInfo = eval('(' + data + ')')[0];

			if(userInfo.nUin) {				
				importFav.isLogon = true;

				$('#logon-username').text(unescape(userInfo.strNickName));
				$('#unlog-title').hide();
				$('#logon-title').show();
				$('#import-qq-local').addClass('enabled');
				$('#import-qq-local-radio').attr('checked', true); // 去掉未登录时ie导入的勾选，加上qq本地导入的选择
				$('#import-ie-radio').attr('checked', false);
			}
		});
	}
	catch (e) {}	
	
	try
	{		
		qqbrowser.dialog.id(function(res) {
			var obj = eval("("+res+")");
			var dialogId=eval("("+unescape(obj[0])+")");
			importFav.dialogId = dialogId;
		});	
	}
	catch (e) {}
	
	
	// 设置close-button的淡入淡出
	$('#close-button').append('<span class="hover"></span>').hover(function() {
	    view.fadeButtonIn.apply(this);
	}, function() {
		var el = this;
	    
		setTimeout(function() {
			if (!el.open) view.fadeButtonOut.apply(el);
		}, 10);
	}).click(function() {
		qqbrowser.dialog.close(0); // 关闭页面
	}); 
	
	// 关闭窗口
	$('#close-bottom-button').click(function() {
		qqbrowser.extension.builtin.statistics.increase(STATIS_FAV_IMPORT_EXPORT_PAGE_CLOSE);
		qqbrowser.dialog.close(0); // 关闭页面
	});
	
	$('#import-button').click(function() {
		// 网络异常时的判断
		if(!importFav.checkSyncStatus()) {
			return;
		}
		if (document.getElementById("clear-old-fav").checked) {
			qqbrowser.extension.builtin.statistics.increase(STATIS_FAV_IMPORT_EXPORT_PAGE_CLEAN);
		}
		try 
		{
			//qqbrowser.extension.builtin.statistics.increase(123016);//上报 导入收藏对话框“导入”按钮点击
			qqbrowser.extension.builtin.statistics.increase(STATIS_FAV_IMPORT_EXPORT_PAGE_IMPORT);
		} 
		catch(e) 
		{
		
		}
		importFav.excute();
	});	
	
	// 判断是否有异常
	try
	{
		qqbrowser.bookmark.getSyncState(function(result) {
			var syncStateId = eval('(' + result + ')')[0];
			if(syncStateId == 2) { // 异常时
				importFav.isSyncError = true;
				importFav.isSyncLoading = false;
			} else if(syncStateId == 1) { // 下载中
				importFav.isSyncError = false;
				importFav.isSyncLoading = true;
			}
			else {
				importFav.isSyncError = false;
				importFav.isSyncLoading = false;
			}
		});
		
		qqbrowser.bookmark.onSyncStateChanged.addListener(function(syncStateId) {
			if(syncStateId == 2) { // 异常时
				importFav.isSyncError = true;	
				importFav.isSyncLoading = false;
			} else if(syncStateId == 1) { // 下载中
				importFav.isSyncLoading = true;
				importFav.isSyncError = false;
			} else {		
				importFav.isSyncError = false;
				importFav.isSyncLoading = false;
			}	
		});
	} catch(e) {}	

	function checkOtherBookmarkExist(type, radioSelector, lableSelector) {
		try {
			//查看360的书签是否存在，4是360的checkbox的索引+1
			qqbrowser.bookmark.isOtherBookmarkExist(type, function(result) {
				var exist = eval('(' + result + ')')[0];
				// 书签数据存在
				if(exist == 1) {
					$(radioSelector).attr('disabled', false);
					// lable不透明
					$(lableSelector).css('opacity', 1);
				}
			});
		} catch(e) {
			
		}
	}
	
	checkOtherBookmarkExist(3, '#import-tt-radio', '#lable_for_tt');
	checkOtherBookmarkExist(4, '#import-360-radio', '#lable_for_360');
	
	function updateImportButtonStatus()
	{
		if( $('#import-qq-local-radio').attr('checked') ||
			$('#import-ie-radio').attr('checked') ||
			$('#import-tt-radio').attr('checked') ||
			$('#import-360-radio').attr('checked') ||
			($('#import-html-radio').attr('checked') &&
				$.trim($('#input').val()) !== '')) {
			$('#import-button').removeClass('disabled');
			$('#import-button').removeAttr('disabled');
		} else {
			$('#import-button').addClass('disabled');
			$('#import-button').attr({disabled: 'disabled'});
		}
	}
	
	// 如果是点击“浏览”按钮获得文件路径，JS获取不到事件，因此无法改变“导入”按钮的状态。
	$(':checkbox, #input').not('#clear-old-fav').change(updateImportButtonStatus);
	$('#input').keyup(function() { // 注：keydown不可以，否则总是检查上一次的
		updateImportButtonStatus();
	});
	
	$('#import-html-radio').click(function() {
		if(!$(this).attr('checked')) {
			$('#select-file').addClass('disabled');
			$('#input, #select-file').attr({disabled: 'disabled'});
		} else {
			$('#select-file').removeClass('disabled');
			$('#input, #select-file').removeAttr('disabled');
		}
	});
	
	$('#select-file').click(function() {
		if($(this).is('.disabled')) {
			return;
		}

		//$(this).attr('disabled', 'disabled');
		
		qqbrowser.extension.builtin.statistics.increase(STATIS_FAV_IMPORT_EXPORT_PAGE_BROWSE);
		var obj = qqbrowser.extension.dllLoader("bookmark.dll");
		obj.execDllFunc("onOpenFileDialog", importFav.dialogId, 'importFav.selectFile');	
	});
	
	window.updateImportButtonStatus = updateImportButtonStatus;
});

var checkedOption = [];

var importFav = {};

var daPosition = 0;
var timeOutIdle;
var waitingAnimateList = new Array('images/importFav/loading/1.png' , 
		'images/importFav/loading/2.png' , 'images/importFav/loading/3.png' , 
		'images/importFav/loading/4.png' , 'images/importFav/loading/5.png' ,
		'images/importFav/loading/6.png' , 'images/importFav/loading/7.png' , 
		'images/importFav/loading/8.png' , 'images/importFav/loading/9.png' ,
		'images/importFav/loading/10.png' , 'images/importFav/loading/11.png');

importFav.isLogon = false;
importFav.isSyncError = false;
importFav.isSyncLoading = false;
importFav.dialogId = 0;

importFav.selectFile = function(result) {
	$('#select-file').attr('disabled', '');

	var filePath = unescape(eval('(' + result + ')')[0]);
	$('#input').val(filePath);
	$('#input').get(0).scrollLeft = 2000; // 显示移到最后
	updateImportButtonStatus();
}

importFav.checkSyncStatus = function() {
	if(!importFav.isLogon || (!importFav.isSyncError && !importFav.isSyncLoading)) { // 未登录时不判断
		return 1;
	}

	if(importFav.isSyncError) {
		importFav.showSyncPopupDownloadTip();
	} else if(importFav.isSyncLoading) {
		importFav.showSyncPopupDownloadEdit();
	}
	
	return 0;
}

/* 显示DownloadTip的同步对话框 */
importFav.showSyncPopupDownloadTip = function() {
	var oParent = {};
	oParent.type = "window";
	oParent.id = qqbrowser.window.currentId();
	qqbrowser.dialog.create(oParent, "aero\\notify.html?status=downloadTip", 336, 170, true, escape(''), true);
}

/* 显示DownloadEdit的同步对话框 */
importFav.showSyncPopupDownloadEdit = function() {
	var oParent = {};
	oParent.type = "window";
	oParent.id = qqbrowser.window.currentId();
	qqbrowser.dialog.create(oParent, "aero\\notify.html?status=downloadEdit", 336, 170, true, escape(''), true);
}

importFav.showDone = function() {
	clearTimeout(timeOutIdle);
	
	$('#import-button').attr('disabled', '').removeClass('disabled');
	
//	$('#tips').append($('#waiting'));
	
	var importDiv = importFav.getCheckedOption();

	if(importDiv.next().is('.fail, .done, .waiting')) {
		importDiv.next().remove();
	}

	$('#done').clone().insertAfter(importDiv);
}

importFav.showFail = function() {
	clearTimeout(timeOutIdle);
	
	$('#import-button').attr('disabled', '').removeClass('disabled');
	
//	$('#tips').append($('#waiting'));
	var importDiv = importFav.getCheckedOption();

	if(importDiv.next().is('.fail, .done, .waiting')) {
		importDiv.next().remove();
	}

	$('#fail').clone().insertAfter(importDiv);
}

/**
 * 显示waiting
 */
importFav.showWaitingAnimate = function() {

	// 屏蔽按钮
	$('#import-button').attr('disabled', 'disabled').addClass('disabled');
	
	var importDiv = importFav.getCheckedOption();
	// 显示等待栏

	if(importDiv.next().is('.fail, .done, .waiting')) {
		importDiv.next().remove();
	}

	$('#waiting').clone().insertAfter(importDiv);
	
	importFav.controlWaitingAnimate();
}

/**
 * 控制动画图片的显示
 */
importFav.controlWaitingAnimate = function() {
	importFav.controlWaitingImg();
}

importFav.controlWaitingImg = function() {
	daPosition = daPosition == waitingAnimateList.length - 1 ? 0 : ++daPosition;
	
	$('#waiting-animate-image').attr('src', waitingAnimateList[daPosition]);

	timeOutIdle = setTimeout("importFav.controlWaitingAnimate()", 100);
}

importFav.excute = function() {
	$('#import-body div.done, #import-body div.fail, #import-body div.waiting').remove();

	checkedOption = [];
	var radios = $("input[type=checkbox]:not(#clear-old-fav)");
	for(var i = 0; i < radios.length; i++) {
		if($(radios[i]).attr('checked')) {
			checkedOption.push(i);
		}
	}
	
	if(checkedOption.length == 0) { // no choice
		return;
	}

	importFav.isClear = $('#clear-old-fav').attr('checked') ? 1 : 0;
	
	if(importFav.isClear && !confirm('您确定要在导入的时候清空QQ浏览器原有的收藏内容吗?')) { // confirm clear
		importFav.isClear = 0;
		$('#clear-old-fav').attr('checked', false);
	} 
	
	importFav.import();
}

importFav.isClear = 0;
importFav.currentCheckbox = -1;

importFav.filePath = '';

importFav.import = function() {
	var filePath = $.trim($('#input').val());
	if($('input[type=checkbox]:eq(' + checkedOption[0] + ')').attr('id')  == 'import-html-radio' && filePath == '') { // 导入html收藏时不允许路径为空
		return;
	}
//	var strPath = ''; // TODO

	try
	{
		importFav.currentCheckbox = checkedOption[0];
		importFav.showWaitingAnimate();

		qqbrowser.bookmark.import(checkedOption[0] + 1, filePath, importFav.isClear, importFav.getResult);

		checkedOption.shift();
		importFav.isClear = 0;
	}
	catch (e) {}
}

importFav.getResult = function(result) {
	result = eval('(' + result + ')');

	if(result[0] == 1) {
		importFav.showDone();
		try 
		{
			//qqbrowser.extension.builtin.statistics.increase(123017);//上报 导入成功
			qqbrowser.extension.builtin.statistics.increase(STATIS_FAV_IMPORT_EXPORT_PAGE_IMPORT_SUCCESS);//上报 导入成功
		} catch(e) {
		
		}
	} else {
		importFav.showFail();
	}

	if(checkedOption.length != 0) {
		importFav.import();
	} 
}

importFav.getCheckedOption = function() {
	return $("input[type=checkbox]:eq(" + importFav.currentCheckbox + ")").parent();
}